#!/bin/bash
set -e

APP_NAME="TinyApps"
APP_IMAGE_DEST="/opt/$APP_NAME/Image.AppImage"
ICON_DEST="$HOME/.local/share/icons/hicolor/256x256/apps/tinyapps.png"
DESKTOP_FILE_DEST="$HOME/.local/share/applications/tinyapps.desktop"

echo "Removing AppImage..."
sudo rm "$APP_IMAGE_DEST"
echo "Removing Icon..."
sudo rm "$ICON_DEST"
echo "Removing Desktop File..."
sudo rm "$DESKTOP_FILE_DEST"

echo "Syncing"
sync

echo "Updating icon cache and desktop database..."
gtk-update-icon-cache ~/.local/share/icons/hicolor/ || true
update-desktop-database ~/.local/share/applications/ || true
