#!/bin/bash
set -e

APP_NAME="TinyApps"
APP_IMAGE_SRC="./files/TinyApps.AppImage"
APP_IMAGE_DEST="/opt/$APP_NAME/Image.AppImage"
ICON_SRC="./files/tinyapps.png"
ICON_DEST="$HOME/.local/share/icons/hicolor/256x256/apps/tinyapps.png"
DESKTOP_FILE_SRC="./files/tinyapps.desktop"
DESKTOP_FILE_DEST="$HOME/.local/share/applications/tinyapps.desktop"

echo "Creating /opt/$APP_NAME and copying AppImage..."
sudo mkdir -p "/opt/$APP_NAME"
sudo cp "$APP_IMAGE_SRC" "$APP_IMAGE_DEST"
sudo chmod +x "$APP_IMAGE_DEST"

echo "Copying icon..."
mkdir -p "$(dirname "$ICON_DEST")"
cp "$ICON_SRC" "$ICON_DEST"

echo "Copying .desktop file..."
mkdir -p "$(dirname "$DESKTOP_FILE_DEST")"
sed "s|Exec=.*|Exec=$APP_IMAGE_DEST|" "$DESKTOP_FILE_SRC" > "$DESKTOP_FILE_DEST"

echo "Syncing"
sync

echo "Updating icon cache and desktop database..."
gtk-update-icon-cache ~/.local/share/icons/hicolor/ || true
update-desktop-database ~/.local/share/applications/ || true

echo "Installation completed!"
echo "You can now launch TinyApps from the application menu."
